unit IWResourceStrings;

interface

const
  EOL = #13#10;

var
  RSOK: string;
  RSPermissionDEnied: string;
  RSShowMessageNotSupported: string;
  RSSecureModeRequired: string;
  RSNonSecureModeRequired: string;
  RSAppStartedAndListening: string;
  RSNotSupportedDuringPartialUpdate: String;
  RSWebApplicationRequiered: String;
  RSOptionsMenuCaption: String;
  RSDeviceSimulationMenuCaption: string;
  RSHTML32Caption: String;
  RSWMLCaption: string;
  RSXHTMLMPCaption: string;
  RSWMLHint: string;
  RSXHTMLMPHint: string;
  RSHTML32Hint: String;
  RSUnknownClientType: String;
  RSCannotShowNonAppForms: String;
  RSCannotHideNonAppForms: String;
  RSCannotReleaseNonAppForms: String;
  RSUnknownBrowserType: String;
  RSMustBeAppForm: String;
  RSPersonalLimitation: String;
  RSWrongIPForSession: String;
  RSWrongBrowserForSession: String;
  RSWrongSubnetForSession: string;
  RSClientSideInEnterprise: String;
  RSValidationRequeredField: String;
  RSInvalidComponentName: String;
  RSDroppedConnection: String;
  RSNotFound: String;
//  RSWarningNonIntraWeb: String;
//  RSWarning32Control: string;
//  RSWarning40Control: string;
//  RSWarningWAPControl: string;
  RSNoSubmitComponent: String;
  RSNoSubmitHandler: String;
  RSInvalidFunction: String;
  RSInvalidHeight: String;
  RSInvalidWidth: String;
  RSIndexOutOfBounds: String;
  RSNoServerController: String;
  RSSessionNotFound: String;
  RSSessionAlreadyLocked: String;
  RSNotForThisProcess: String;
  RSRefreshWarning: String;
  RSResourceNotFound: String;
  RSNoMainForm: String;
  RSDeviceNotSupported: string;
  RSNoServerControllerClass: String;
  RSIWInitMissing: String;
  RSUnknownSessionMethod: String;
  RSInvalidBrowser: String;
  RSMessageDialog: String;
  RSColorRed: String;
  RSColorBlue: String;
  RSColorGreen: String;
  RSColorYellow: String;
  RSColorBrown: String;
  RSTextError: String;
  RSCannotReceiveFocus: string;
  RSErrorCreatingSession: string;
  // Browsers
  RSUnknowBrowser: String;
  RSIE: String;
  RSNS6Gecko: String;
  RSNS7Gecko: String;
  RSOpera: String;
  RSUnrecognizable: String;
  RSSafari: String;
  RSNS4: string;
  RSWAP: string;
  RSOther: string;
  RSHTML32Test: string;
  RSWMLTest: string;
  RSXHTMLMPTest: string;
  RSNoCookieSupport: String;
  RSNoJSSupport: string;
  //
  RSCantFindInternalFile: String;
  RSExecuteError: String;
  // Standalone Log messages
  RSIWVersion: String;
  RSHTTPPort: String;
  RSHTTPSPort: String;
  RSBindError: String;
  RSLicenseNumber: String;
  // Navigator buttons
  RSbtnNameFirst: String;
  RSbtnNamePrior: String;
  RSbtnNameNext: String;
  RSbtnNameLast: String;
  RSbtnNameInsert: String;
  RSbtnNameDelete: String;
  RSbtnNameEdit: String;
  RSbtnNamePost: String;
  RSbtnNameCancel: String;
  RSbtnNameRefresh: String;

  // DB package
  RSUnsupportedFieldType: String;
  RSNoRefereshWhileInEdit: String;
  RSInvalidResponse: String;
  RSDeleteMessage: String;
  RSUpdateMessage: String;
  RSCancelMessage: String;
  // Design time
  RSInvalidSessionTimeout: string;
  RSEmptyWorkAreaPath: String;
  RSFormPreviewError: String;
  RSHTMLEditorError: String;
  RSIE55OrLater: String;
  RSScriptEditorCaption: String;
  RSScriptEditorEvent: String;
  RSScriptEditorCode: String;
  RSOKButton: String;
  RSCancelButton: String;
  RSApplyButton: String;
  // TreeVew designer
  RSNewRoot: String;
  RSNewItem: String;
  RSDeleteItem: String;
  RSEditCaption: String;
  RSMsgDeleteItem: String;
  // Run-time only units not part of any of the packages
  RSApacheDSOError: String;
  RSISAPIError: String;
  RSStandaloneError: String;
  RSAuthFailed: String;
  RSToolBarError: String;
  RSRedirecting: String;

  RSCanUseIWControlOnVCLForm: String;
  RS4On32Form: String;
  RS32On4Form: String;

  RSDublicateEventHandler: String;
  RSMetaFileNotSupported: String;
  RSLoadImageError: String;
  RSUnrecognizedCommand: String;
  RSLayoutMgrNeeded32: String;
  // Log Messages
  RSLogExecute: String;
  RSLogCacheFile: String;
  RSLogInternalGraphic: String;
  RSLogJavaScript: String;
  RSLogNewSession: String;
  RSLogExternalFile: String;
  RSLogExplicitStop: String;
  RSLogUnrecognizedCommand: String;
  RSLogActiveSessions: String;
  RSLogTotalBytes: string;
  RSLogResizeCommand: String;
  RSLogUpdateCommand: String;
  // IWMain
  RSClearSessionsCaption: String;
  RSClearSessionsHint: String;
  RSCopyClipboardCaption: String;
  RSCopyClipboardHint: String;
  RSShowDebugInfoCaption: String;
  RSShowDebugInfoHint: String;
  RSExitCaption: String;
  RSExitHint: String;
  RSExecuteCaption: String;
  RSExecuteHint: String;
  RSExecuteDefaultCaption: String;
  RSExecuteDefaultHint: String;
  RSExecuteIECaption: String;
  RSExecuteIEHint: String;
  RSExecuteMozillaCaption: String;
  RSExecuteMozillaHint: String;
  RSExecuteFirefoxCaption: String;
  RSExecuteFirefoxHint: String;
  RSExecuteNS6Caption: String;
  RSExecuteNS6Hint: String;
  RSExecuteOperaCaption: String;
  RSExecuteOperaHint: String;
  RSUseSSLCaption: String;
  RSUseSSLHint: String;
  RSParamCaption: String;
  RSParamHint: String;
  RSAboutCaption: String;
  RSAboutHint: String;
  RSFileMenuCaption: String;
  RSRunMenuCaption: String;
  RSSelectBrowserCaption: String;
  RSHelpCaption: String;
  RSToolBarCaption: String;
  RSUseParamQueryTitle: String;
  RSUseParamQueryPrompt: String;
  RSCanSetControlToSelf: String;
  RSSelectionRequired: String;
  RSConnectionSpeedCaption: string;
  RSIncorrectSpeed: string;
  RSSimulSpeed: string;
  RSConnectionSpeed: string;
  // IWCompress
  RSZLibNotFound: string;
  RSWrongZLibVer: string;
  // Calendar
  RSToday: string;
  RSPrevious: string;
  RSNext: string;
  // Desinger menu items
  rsEditHTML: string;
  rsPreviewHTML: string;

  // TimeEdit
  RSInvalidTimeEditFormat: string;

  RSMissingContainerOnFrame : string; // Display this when there's no container on a TFrame

  RSLogCSSRequest: string;

  // Error messages
  RSExceptionSessionExpired : string;
  RSExceptionOther : string;
  RSTrappedException: string;

implementation

resourcestring
  Ok = 'Ok';
  PermissionDenied = 'Permission denied';
  ShowMessageNotSupported = 'ShowMessage not supported';
  SecureModeRequired = 'Secure mode is required for this form.';
  NonSecureModeRequired = 'Non-Secure mode is required for this form.';
  AppStartedAndListening = 'Application initialized and listening on port: ';
  NotSupportedDuringPartialUpdate = 'That change is not supported during partial update.';
  WebApplicationRequiered = 'WebApplication is requiered in order to use this function.';
  TerminateAndRedirectMsg = 'Please wait a moment.';
  OptionsMenuCaption = '&Options';
  DeviceSimulationMenuCaption = '&Device Simulation';
  HTML32Caption = 'HTML 3.2';
  WMLCaption = 'WML';
  XHTMLMPCaption = 'XHTML MP';
  HTML32Hint = 'Override browser type and use HTML 3.2 mode.';
  WMLHint = 'Override browser type and use WML mode.';
  XHTMLMPHint = 'Override browser type and use XHTML MP mode';
  UnknownClientType = 'Unknown client type.';
  CannotShowNonAppForms = 'Cannot show non-app forms.';
  CannotHideNonAppForms = 'Cannot hide non-app forms.';
  CannotReleaseNonAppForms = 'Cannot release non-app forms.';
  UnknownBrowserType = 'Unknown browser type.';
  MustBeAppForm = 'Form must be an application form.';
  WrongIPForSession = 'Security Exception: The IP you are using is different than the one that is assigned to the specified session.';
  WrongBrowserForSession = 'Security Exception: The browser you are using is different than the one that is assigned to the specified session.';
  WrongSubnetForSession = 'Security Exception: The IP you are using is from a different subnet than the one that is assigned to the specified session.';
  ValidationRequeredField = '%s is a required field.';
  SelectionRequired = 'A value must be selected for %s.';
  InvalidComponentName = '"%s" is not a valid component name.';
  DroppedConnection = 'Client Dropped Connection';
  NotFound = '%s not found.';
//  WarningNonIntraWeb = 'Warning: You have added a Non-IntraWeb control. %s';
//  Warning32Control = 'Warning: You have added a 3.2 IntraWeb control to a non-3.2 Form. %s';
//  Warning40Control = 'Warning: You have added a 4.0 IntraWeb control to a non-4.0 Form. %s';
//  WarningWAPControl = 'Warning: You have added a WAP IntraWeb control to a non-WAP form. %s';
  NoSubmitComponent = 'Cannot find submit component.';
  NoSubmitHandler = 'Submit control (%s) does not have a handler.';
  InvalidFunction = 'This function is not valid for this server type.';
  InvalidHeight = '"%s" is not a valid height.';
  InvalidWidth = '"%s" is not a valid width.';
  IndexOutOfBounds = 'Index out of bounds.';
  NoServerController = 'No server controller has been created.';
  SessionNotFound = 'Session not found. Session may have expired.';
  SessionAlreadyLocked = 'Session is already locked.';
  NotForThisProcess = 'The session does not belong to this process.';
  RefreshWarning = 'You have attempted to post or refresh data from a page that '
         + ' depends on information that is no longer available to the server application.'
         + EOL + EOL
         + 'Your attempted changes will be ignored. You will now be resynced to the current place'
         + ' in the application.';
  ResourceNotFound = 'Resource %s not found.';
  NoMainForm = 'No main form is defined.';
  DeviceNotSupported = 'Device not supported';
  NoServerControllerClass = 'No server controller is defined.';
  IWInitMissing = 'IW application not initialized (IWInit missing).';
  UnknownSessionMethod = 'Unknown session tracking method';
  InvalidBrowser = 'Your browser was detected as %s, identifying itself as %s.' + EOL + 'One of the following browsers is required:' + EOL;
  MessageDialog = 'Message Dialog';
  ColorRed = 'red';
  ColorBlue = 'blue';
  ColorGreen = 'green';
  ColorYellow = 'yellow';
  ColorBrown = 'brown';
  TextError = 'Error: ';
  CannotReceiveFocus = 'Control cannot receive focus';
  ErrorCreatingSession = 'Error creating session';
  // Browsers
  UnknowBrowser = 'Unknown or Unrecognized';
  IE = 'Internet Explorer';
  NS6Gecko = 'Netscape 6 (Gecko)';
  NS7Gecko = 'Netscape 7 or higher (Gecko)';
  Opera = 'Opera';
  NS4 = 'Netscape 4';
  Other = 'Other';
  HTML32Test = 'HTML 32 Test';
  WMLTest = 'WML Test';
  WAP = 'Generic WAP Browser';
  XHTMLMPTest = 'XHTML MP Test';
  Safari = 'Safari';
  Unrecognizable = 'Unknown browser type.';
  NoCookieSupport = 'Your browser does not seem to support cookies or they are disactivated';
  NoJSSupport = 'Your browser does not seem to support JavaScript. Please make sure it is supported and activated';

  //
  CantFindInternalFile = 'Cannot find internal file: %s';
  ExecuteError = 'Error %s while launching browser.';
  // Standalone Log messages
  IWVersion = 'Intraweb Version: %s';
  HTTPPort = 'HTTP Port: %s';
  HTTPSPort = 'HTTPS Port: %s';
  BindError = 'Warning: Port has been assigned by system.';
  LicenseNumber = 'License Number: %s';
  // Navigator buttons
  btnNameFirst = 'First';
  btnNamePrior = 'Prior';
  btnNameNext = 'Next';
  btnNameLast = 'Last';
  btnNameInsert = 'Insert';
  btnNameDelete = 'Delete';
  btnNameEdit = 'Edit';
  btnNamePost = 'Post';
  btnNameCancel = 'Cancel';
  btnNameRefresh = 'Refresh';

  // DB package
  UnsupportedFieldType = 'Unsupported field type in DBLink';
  NoRefereshWhileInEdit = 'Cannot refresh grid while data is in edit or insert mode.';
  InvalidResponse = '%s is not a valid response.';
  DeleteMessage = 'Are you sure you want to delete this record?';
  UpdateMessage = 'Are you sure you want to update this record?';
  CancelMessage = 'Are you sure you want to cancel your changes to this record?';
  // Design time
  InvalidSessionTimeout = 'Invalid session timeout value.';
  EmptyWorkAreaPath = 'Work Area Path not set.';
  FormPreviewError = 'Error loading Form Preview Manager. Check to see if it is installed.';
  HTMLEditorError = 'Error loading HTML Layout Manager. Check to see if it is installed.';
  IE55OrLater = 'Internet Explorer 5.5 or higher is required to run the editor';
  ScriptEditorCaption = 'IntraWeb Event Scripts Editor';
  ScriptEditorEvent = 'Event';
  ScriptEditorCode = 'Code';
  OKButton = 'OK';
  CancelButton = 'Cancel';
  ApplyButton = '&Apply';
  // TreeVew designer
  NewRoot = 'New &Root Item';
  NewItem = '&New Item';
  DeleteItem = '&Delete Item';
  EditCaption = '&Edit Caption';
  MsgDeleteItem = 'Delete "%s"?';
  // Run-time only units not part of any of the packages
  ApacheDSOError = 'Apache DSOs must be a library.';
  ISAPIError = 'ISAPI version must be a library.';
  StandaloneError = 'Standalone must be .exe';
  AuthFailed = 'Authentication Failed.';
  ToolBarError = 'Error loading toolbar button images.';
  Redirecting = 'Redirecting...';

  CanUseIWControlOnVCLForm = 'IntraWeb controls can only be placed on IntraWeb forms or Delphi frames';
  No4On32Form = 'Only 3.2 controls should be placed on a 3.2 Form';
  No32On4Form = 'Only 4.0 controls should be placed on a 4.0 Form';

  DublicateEventHandler = 'This event handler already has code associated to it';
  MetaFileNotSupported = 'MetaFile not supported';
  LoadImageError = 'Could not load image';
  UnrecognizedCommand = 'Unrecognized Command: ';
  LayoutMgrNeeded32 = 'For HTML 3.2 a layout manager is required. Make sure that you have one' + EOL
  + ' associated to the form and this it''s Able property is set to True';
  // Log Messages
  LogExecute = 'Execute: ';
  LogCacheFile = 'Cache File: ';
  LogInternalGraphic = 'Internal Graphic: ';
  LogJavaScript = 'Javascript: ';
  LogNewSession = 'New session: ';
  LogExternalFile = 'External File: ';
  LogExplicitStop = 'Explicit Stop: ';
  LogUnrecognizedCommand = 'Unrecognized Command: ';
  LogActiveSessions = 'Active Sessions: ';
  LogTotalBytes = 'Sent: ';
  LogResizeCommand = 'Resize: ';
  LogUpdateCommand = 'Partial Update: ';
  // IWMain
  ClearSessionsCaption = 'C&lear Sessions';
  ClearSessionsHint = 'Clear all active sessions.';
  CopyClipboardCaption = '&Copy URL to Clipboard';
  CopyClipboardHint = 'Copies the starting URL for the application to the clipboard.';
  ShowDebugInfoCaption = '&Show Debug Information';
  ShowDebugInfoHint =  'Shows detailed debug information in the log window.';
  ExitCaption = 'E&xit';
  ExitHint = 'Stop the service and exit the application.';
  ExecuteCaption = 'E&xecute';
  ExecuteHint = 'Launch selected browser and execute application.';
  ExecuteDefaultCaption = 'Execute via &Default browser';
  ExecuteDefaultHint = 'Launch default browser and execute application.';
  ExecuteIECaption = 'Execute via &IE';
  ExecuteIEHint = 'Launch Internet Explorer and execute application.';
  ExecuteMozillaCaption = 'Execute via &Mozilla';
  ExecuteMozillaHint = 'Launch Mozilla and execute application.';
  ExecuteFirefoxCaption = 'Execute via &Firefox';
  ExecuteFirefoxHint = 'Launch Firefox and execute application.';
  ExecuteNS6Caption = 'Execute via &Netscape';
  ExecuteNS6Hint = 'Launch Netscape and execute application.';
  ExecuteOperaCaption = 'Execute via &Opera';
  ExecuteOperaHint = 'Launch Opera and execute application.';
  UseSSLCaption = 'Use SS&L';
  UseSSLHint = 'Use SS&L';
  ParamCaption = '&Parameters';
  ParamHint = 'Set parameters for application.';
  AboutCaption = '&About';
  AboutHint = 'Display about box.';
  FileMenuCaption = '&File';
  RunMenuCaption = '&Run';
  SelectBrowserCaption = 'Select browser';
  HelpCaption = '&Help';
  ToolBarCaption = 'Toolbar';
  UseParamQueryTitle = 'URL Parameters';
  UseParamQueryPrompt = 'Enter parameters for URL:';
  ConnectionSpeedCaption = 'Set Simulated Connection speed';
  IncorrectSpeed = 'Incorrect connection speed value (%s).';
  SimulSpeed = 'Simulated Connection speed';
  ConnectionSpeed = 'Connection Speed: ';

  CanSetControlToSelf = 'You cannot assign the control to itself';

  // IWCompress
  ZLibNotFound = 'zlib.dll       not found in %s';
  WrongZLibVer = 'Wrong ZLib version';

  // Calendar
  Today = 'Today';
  Previous = 'Previous';
  Next = 'Next';
  // Designer menu items
  EditHTML = 'Edit';
  PreviewHTML = 'Preview';

  // TimeEdit
  InvalidTimeEditFormat = 'The value of %s is in an incorrect format.' + EOL +  'Please correct the value.';

  MissingContainerOnFrame = 'Frame container not found.';
  LogCSSRequest = 'CSS: ';

  // Errors
  ExceptionSessionExpired = 'Your session has expired. You will have to restart the application. In order to keep sessions from ' +
      'expiring you may set the session timeout parameter to a higher value. The current session timeout value is %d minute%s.';
  ExceptionOther = 'Depending on the error condition, it might be possible to restart the application.';
  TrappedException = 'The following exception%s occured'#13#10'%s';


initialization
  RSOk := OK;
  RSShowMessageNotSupported := ShowMessageNotSupported;
  RSSecureModeRequired := SecureModeRequired;
  RSNonSecureModeRequired := NonSecureModeRequired;
  RSAppStartedAndListening := AppStartedAndListening;
  RSNotSupportedDuringPartialUpdate := NotSupportedDuringPartialUpdate;
  RSWebApplicationRequiered :=   WebApplicationRequiered;
  RSOptionsMenuCaption :=        OptionsMenuCaption;
  RSDeviceSimulationMenuCaption :=   DeviceSimulationMenuCaption;
  RSHTML32Caption :=             HTML32Caption;
  RSWMLCaption :=                WMLCaption;
  RSXHTMLMPCaption :=            XHTMLMPCaption;
  RSHTML32Hint :=                HTML32Hint;
  RSWMLHint :=                   WMLHint;
  RSXHTMLMPHint :=               XHTMLMPHint;
  RSUnknownClientType :=         UnknownClientType;
  RSCannotShowNonAppForms :=     CannotShowNonAppForms;
  RSCannotHideNonAppForms :=     CannotHideNonAppForms;
  RSCannotReleaseNonAppForms :=  CannotReleaseNonAppForms;
  RSUnknownBrowserType :=        UnknownBrowserType;
  RSMustBeAppForm :=             MustBeAppForm;
  RSWrongIPForSession :=         WrongIPForSession;
  RSWrongBrowserForSession :=    WrongBrowserForSession;
  RSWrongSubnetForSession :=     WrongSubnetForSession;
  RSValidationRequeredField :=   ValidationRequeredField;
  RSInvalidComponentName :=      InvalidComponentName;
  RSDroppedConnection :=         DroppedConnection;
  RSNotFound :=                  NotFound;
//  RSWarningNonIntraWeb :=        WarningNonIntraWeb;
//  RSWarning32Control :=          Warning32Control;
//  RSWarning40Control :=          Warning40Control;
//  RSWarningWAPControl :=         WarningWAPControl;
  RSNoSubmitComponent :=         NoSubmitComponent;
  RSNoSubmitHandler :=           NoSubmitHandler;
  RSInvalidFunction :=           InvalidFunction;
  RSInvalidHeight :=             InvalidHeight;
  RSInvalidWidth :=              InvalidWidth;
  RSIndexOutOfBounds :=          IndexOutOfBounds;
  RSNoServerController :=        NoServerController;
  RSSessionNotFound :=           SessionNotFound;
  RSSessionAlreadyLocked :=      SessionAlreadyLocked;
  RSNotForThisProcess :=         NotForThisProcess;
  RSRefreshWarning :=            RefreshWarning;
  RSResourceNotFound :=          ResourceNotFound;
  RSNoMainForm :=                NoMainForm;
  RSDeviceNotSupported :=        DEviceNotSupported;
  RSNoServerControllerClass :=   NoServerControllerClass;
  RSIWInitMissing :=             IWInitMissing; 
  RSUnknownSessionMethod :=      UnknownSessionMethod;
  RSInvalidBrowser :=            InvalidBrowser;
  RSNoJSSupport :=               NoJSSupport;
  RSMessageDialog :=             MessageDialog;
  RSColorRed :=                  ColorRed;
  RSColorBlue :=                 ColorBlue;
  RSColorGreen :=                ColorGreen;
  RSColorYellow :=               ColorYellow;
  RSColorBrown :=                ColorBrown;
  RSTextError :=                 TextError;
  RSCannotReceiveFocus :=        CannotReceiveFocus;
  RSErrorCreatingSession :=      ErrorCreatingSession;
  RSPermissionDenied :=          PermissionDenied;
  RSUnknowBrowser :=             UnknowBrowser;
  RSIE :=                        IE;
  RSNS6Gecko :=                  NS6Gecko;
  RSNS7Gecko :=                  NS7Gecko;
  RSSafari :=                    Safari;
  RSOpera :=                     Opera;
  RSNS4 :=                       NS4;
  RSOther :=                     Other;
  RSHTML32Test :=                HTML32Test;
  RSWMLTest :=                   WMLTest;
  RSWAP :=                       WAP;
  RSXHTMLMPTest :=               XHTMLMPTest;
  RSUnrecognizable :=            Unrecognizable;
  RSNoCookieSupport :=           NoCookieSupport;

  RSCantFindInternalFile :=      CantFindInternalFile;
  RSExecuteError :=              ExecuteError;

  RSIWVersion :=                 IWVersion;
  RSHTTPPort :=                  HTTPPort;
  RSHTTPSPort :=                 HTTPSPort;
  RSBindError :=                 BindError;
  RSLicenseNumber :=             LicenseNumber;

  RSbtnNameFirst :=              btnNameFirst;
  RSbtnNamePrior :=              btnNamePrior;
  RSbtnNameNext :=               btnNameNext;
  RSbtnNameLast :=               btnNameLast;
  RSbtnNameInsert :=             btnNameInsert;
  RSbtnNameDelete :=             btnNameDelete;
  RSbtnNameEdit :=               btnNameEdit;
  RSbtnNamePost :=               btnNamePost;
  RSbtnNameCancel :=             btnNameCancel;
  RSbtnNameRefresh :=            btnNameRefresh;

  RSUnsupportedFieldType :=      UnsupportedFieldType;
  RSNoRefereshWhileInEdit :=     NoRefereshWhileInEdit;
  RSInvalidResponse :=           InvalidResponse;
  RSDeleteMessage :=             DeleteMessage;
  RSUpdateMessage :=             UpdateMessage;
  RSCancelMessage :=             CancelMessage;

  RSInvalidSessionTimeout := InvalidSessionTimeout;
  RSEmptyWorkAreaPath :=         EmptyWorkAreaPath;
  RSFormPreviewError :=          FormPreviewError;
  RSHTMLEditorError :=           HTMLEditorError;
  RSIE55OrLater :=               IE55OrLater;
  RSScriptEditorCaption :=       ScriptEditorCaption;
  RSScriptEditorEvent :=         ScriptEditorEvent;
  RSScriptEditorCode :=          ScriptEditorCode;  
  RSOKButton :=                  OKButton;
  RSCancelButton :=              CancelButton;
  RSApplyButton :=               ApplyButton;

  RSNewRoot :=                   NewRoot;
  RSNewItem :=                   NewItem;
  RSDeleteItem :=                DeleteItem;
  RSEditCaption :=               EditCaption;
  RSMsgDeleteItem :=             MsgDeleteItem;

  RSApacheDSOError :=            ApacheDSOError;
  RSISAPIError :=                ISAPIError;
  RSStandaloneError :=           StandaloneError;
  RSAuthFailed :=                AuthFailed;
  RSToolBarError :=              ToolBarError;
  RSRedirecting :=               Redirecting;

  RSCanUseIWControlOnVCLForm :=  CanUseIWControlOnVCLForm;
  RS4On32Form :=                 No4On32Form;
  RS32On4Form :=                 No32On4Form;

  RSDublicateEventHandler :=     DublicateEventHandler;
  RSMetaFileNotSupported :=      MetaFileNotSupported;
  RSLoadImageError :=            LoadImageError;
  RSUnrecognizedCommand :=       UnrecognizedCommand;
  RSLayoutMgrNeeded32 :=         LayoutMgrNeeded32;

  RSLogExecute :=                LogExecute;
  RSLogCacheFile :=              LogCacheFile;
  RSLogInternalGraphic :=        LogInternalGraphic;
  RSLogJavaScript :=             LogJavaScript;
  RSLogNewSession :=             LogNewSession;
  RSLogExternalFile :=           LogExternalFile;
  RSLogExplicitStop :=           LogExplicitStop;
  RSLogUnrecognizedCommand :=    LogUnrecognizedCommand;
  RSLogActiveSessions :=         LogActiveSessions;

  RSClearSessionsCaption :=      ClearSessionsCaption;
  RSClearSessionsHint :=         ClearSessionsHint;
  RSCopyClipboardCaption :=      CopyClipboardCaption;
  RSCopyClipboardHint :=         CopyClipboardHint;
  RSShowDebugInfoCaption :=      ShowDebugInfoCaption;
  RSShowDebugInfoHint :=         ShowDebugInfoHint;
  RSExitCaption :=               ExitCaption;
  RSExitHint :=                  ExitHint;
  RSExecuteCaption :=            ExecuteCaption;
  RSExecuteHint :=               ExecuteHint;
  RSExecuteDefaultCaption :=     ExecuteDefaultCaption;
  RSExecuteDefaultHint :=        ExecuteDefaultHint;
  RSExecuteIECaption :=          ExecuteIECaption;
  RSExecuteIEHint :=             ExecuteIEHint;
  RSExecuteMozillaCaption :=     ExecuteMozillaCaption;
  RSExecuteMozillaHint :=        ExecuteMozillaHint;
  RSExecuteFirefoxCaption :=     ExecuteFirefoxCaption;
  RSExecuteFirefoxHint :=        ExecuteFirefoxHint;
  RSExecuteNS6Caption :=         ExecuteNS6Caption;
  RSExecuteNS6Hint :=            ExecuteNS6Hint;
  RSExecuteOperaCaption :=       ExecuteOperaCaption;
  RSExecuteOperaHint :=          ExecuteOperaHint;
  RSUseSSLCaption :=             UseSSLCaption;
  RSUseSSLHint :=                UseSSLHint;
  RSParamCaption :=              ParamCaption;
  RSParamHint :=                 ParamHint;
  RSAboutCaption :=              AboutCaption;
  RSAboutHint :=                 AboutHint;
  RSFileMenuCaption :=           FileMenuCaption;
  RSRunMenuCaption :=            RunMenuCaption;
  RSSelectBrowserCaption :=      SelectBrowserCaption;
  RSHelpCaption :=               HelpCaption;
  RSToolBarCaption :=            ToolBarCaption;
  RSUseParamQueryTitle :=        UseParamQueryTitle;
  RSUseParamQueryPrompt :=       UseParamQueryPrompt;
  RSCanSetControlToSelf :=       CanSetControlToSelf;
  RSSelectionRequired :=         SelectionRequired;
  RSConnectionSpeedCaption :=    ConnectionSpeedCaption;
  RSIncorrectSpeed :=            IncorrectSpeed;
  RSSimulSpeed :=                SimulSpeed;
  RSConnectionSpeed :=           ConnectionSpeed;

  RSZLibNotFound :=              ZLibNotFound;
  RSWrongZLibVer :=              WrongZLibVer;

  RSToday :=                     Today;
  RSPrevious :=                  Previous;
  RSNext :=                      Next;
  rsEditHTML :=                  EditHTML;
  rsPreviewHTML :=               PreviewHTML;

  RSLogResizeCommand := LogResizeCommand;
  RSLogUpdateCommand := LogUpdateCommand;

  RSInvalidTimeEditFormat := InvalidTimeEditFormat;
  RSMissingContainerOnFrame := MissingContainerOnFrame;

  RSLogTotalBytes := LogTotalBytes;

  RSLogCSSRequest := LogCSSRequest;

  RSExceptionSessionExpired := ExceptionSessionExpired;
  RSExceptionOther := ExceptionOther;

  RSTrappedException := TrappedException;

end.
